<?php
/**
 * Responsible for rendering the WooCommerce Product Data admin settings
 *
 * @package woo_custom_emails_domain\admin
 */

class Woo_Product_Data_Admin {

	private $version;

	public function add_woo_custom_emails_tab( $original_prodata_tabs ) {
		$this->options = get_option( 'woocustomemails_settings_name' );
		$display_classes_default = 'show_if_simple, show_if_variable, show_if_external, show_if_downloadable, show_if_grouped';
		$display_classes_setting = '';

		if( isset( $this->options['display_classes'] ) ) {
			// Data is set
			$display_classes_setting = $display_classes_default . ', ' . $this->options['display_classes'];
		} else {
			// No Data set
			$display_classes_setting = $display_classes_default;
		}

		// Remove whitespace
		$display_classes_setting = str_replace(' ', '', $display_classes_setting);

		// Turn string into array
		$display_classes_arr = explode(",", $display_classes_setting);

		$new_custom_tab['woo-custom-emails'] = array(
			'label' => __( 'Custom Emails', 'woocommerce' ),
			'target' => 'woo_custom_emails_product_data',
			'class' => $display_classes_arr,
		);

		$insert_at_position = 2; // position in tab list

		$tabs = array_slice( $original_prodata_tabs, 0, $insert_at_position, true ); // Split the tabs into an array, then keep the first part up until our position number
		$tabs = array_merge( $tabs, $new_custom_tab ); // Add our new tab into the array
		$tabs = array_merge( $tabs, array_slice( $original_prodata_tabs, $insert_at_position, null, true ) ); // Append the last part of tabs array

		return $tabs;

	}

	public function wce_custom_admin_style() {

		include_once( dirname(__FILE__) . '/woocustomemails-admin-styles.css' );

	}

	public function wce_enqueue_custom_admin_style() {

		global $pagenow;

		if ( $pagenow !== 'edit.php' ) {
			return;
		}

		wp_register_style( 'wcepp_custom_admin_css', plugins_url( 'woocustomemails-admin-styles.css', __FILE__ ), '1.0', false );
        wp_enqueue_style( 'wcepp_custom_admin_css' );

		include_once( dirname(__FILE__) . '/woocustomemails-admin-styles.css' );

	}

	// Setup 'Custom Emails' Product Data tab
	public function add_woo_custom_emails_tab_fields() {

		global $post;

		// Get WCE Settings
		$this->options = get_option( 'woocustomemails_settings_name' );
		$show_old_content = false;

		// Get Meta from this Post
		$this_product_id = get_the_ID();
		$customcontent_meta = get_post_meta( $this_product_id, 'custom_content', true );

		// Note the 'id' attribute MUST match the 'target' parameter set above.
		?>
		<div id='woo_custom_emails_product_data' class='panel woocommerce_options_panel'>


			<!-- // 2.2.0
			************************************************************* // -->
			<div class='options_group'>

				<div class="wce-product-options-table">

					<?php
					$status_title = __('Order Status', 'woocommerce' );
					$status_tip = __('The Order Status Email which is automatically generated by WooCommerce.', 'woocommerce' );
					$message_title = __('Custom Email Message', 'woocommerce' );
					$message_tip = __('Select a Custom Email Message to be displayed in the Order Status email.', 'woocommerce' );
					$location_title = __('Content Location', 'woocommerce' );
					$location_tip = __('Select where your custom content will display in the Order Status email.', 'woocommerce' );
					?>

					<div class="table-header">
						<div class="status">
							<?php echo $status_title; ?>
							<span class="woocommerce-help-tip" data-tip="<?php echo $status_tip; ?>"></span>
						</div>
						<div class="message">
							<?php echo $message_title; ?>
							<span class="woocommerce-help-tip" data-tip="<?php echo $message_tip; ?>"></span>
						</div>
						<div class="location">
							<?php echo $location_title; ?>
							<span class="woocommerce-help-tip" data-tip="<?php echo $location_tip; ?>"></span>
						</div>
						<?php
						// TODO: Add "PREVIEW" page link to show users what the Custom Email will look like
						?>
					</div>

					<?php
					$customcontent_orderstatus = get_post_meta( $this_product_id, 'order_status', true );
					$customcontent_location = get_post_meta( $this_product_id, 'location', true );

					/*
					* Reusable function to return the title of a WCE Message
					*/
					function getMessageTitle( $msgID = 0, $statusName = '' ) {

						$wcemessage_title = get_the_title( $msgID );
						$editURL = admin_url('post.php?post='.$msgID.'&action=edit');
						$editBtn = '<a href="'.$editURL.'" target="_blank" class="button edit-wcemessage" alt="'.__('Edit','woocommerce').'" title="'.__('Edit','woocommerce').'"><span class="dashicons dashicons-edit"></span></a>';

						// Check if this message is Published.
						if ( get_post_status( $msgID ) !== 'publish' ) {
							// Saved WCE Message is not published, show Invalid message.
							$wcemessage_saved_text = '(' . __('Invalid Message Selected', 'woocommerce') . ')';
						} else {
							// Saved WCE Message is published.
							$wcemessage_saved_text = $wcemessage_title . '';
						}

						$defaultSearchMsg = __( 'Search Custom Messages...', 'woocommerce' );
						$returnStr = '<input class="wcemessage_search_field_input" type="text" value="'.$wcemessage_saved_text.'" name="wcemessage_search_'.$statusName.'" id="wcemessage_search_'.$statusName.'" placeholder="'. $defaultSearchMsg .'" autocomplete="off"></input>';
						return $returnStr;

					}

					/*
					* Reusable function to display the saved WCE Message
					*/
					function showSavedMessage( $statusName = '' ) {

						// set Status "slug"
						if ($statusName == 'onhold'){
							$statusSlug = 'on-hold';
						} else {
							$statusSlug = $statusName;
						}

						$postID = get_the_ID();
						$wcemessage_id = get_post_meta( $postID, 'wcemessage_id', true );
						$wcemessage_id_currentStatus = '';
						$wcemessage_id_currentStatus = get_post_meta( $postID, 'wcemessage_id_'.$statusName, true );
						$wcemessage_controls = '';
						$customcontent_orderstatus = '';
						$customcontent_orderstatus = get_post_meta( $postID, 'order_status', true );

						$extraBtnContainerOpen = '<div class="button-container">';
						$extraBtnContainerOpenRemoveEdit = '<div class="button-container remove edit">';
						$extraBtnContainerClose = '</div>';

						?>
						<div class="form-field wcemessage_search_field">
							<?php
							// if NEW 2.2.0 data is saved for this Order Status
							if ( !empty( $wcemessage_id_currentStatus ) ) {

								echo getMessageTitle( $wcemessage_id_currentStatus, $statusName );

								$editURL = admin_url('post.php?post='.$wcemessage_id_currentStatus.'&action=edit');
								$editBtn = '<a href="'.$editURL.'" target="_blank" class="button edit-wcemessage" alt="'.__('Edit','woocommerce').'" title="'.__('Edit','woocommerce').'"><span class="dashicons dashicons-edit"></span></a>';
								$removeBtn = '<a href="#" class="button remove-wcemessage" alt="'.__('Remove','woocommerce').'" title="'.__('Remove','woocommerce').'"><span class="dashicons dashicons-no"></span></a>';

								$wcemessage_controls = $extraBtnContainerOpenRemoveEdit . $removeBtn . $editBtn . $extraBtnContainerClose;

							} else {

								// if previous data is saved for this Order Status
								if ( $customcontent_orderstatus == ( 'woocommerce_order_status_'.$statusSlug ) ) {

									// Check if a message ID has been assigned
									if ( !empty( $wcemessage_id ) ){

										$wcemessage_title = get_the_title( $wcemessage_id );
										$editURL = admin_url('post.php?post='.$wcemessage_id.'&action=edit');
										$editBtn = '<a href="'.$editURL.'" target="_blank" class="button edit-wcemessage" alt="'.__('Edit','woocommerce').'" title="'.__('Edit','woocommerce').'"><span class="dashicons dashicons-edit"></span></a>';
										$removeBtn = '<a href="#" class="button remove-wcemessage" alt="'.__('Remove','woocommerce').'" title="'.__('Remove','woocommerce').'"><span class="dashicons dashicons-no"></span></a>';
										$wcemessage_controls = $extraBtnContainerOpenRemoveEdit . $removeBtn . $editBtn . $extraBtnContainerClose;

										// Check if this message is Published
										if ( get_post_status( $wcemessage_id ) !== 'publish' ) {
											// Saved WCE Message is not published, show Invalid message
											$wcemessage_saved_text = '(' . __('Invalid Message Selected', 'woocommerce') . ')';
										} else {
											// Saved WCE Message is published
											$wcemessage_saved_text = $wcemessage_title . '';
										}
										?>
										<input class="wcemessage_search_field_input" type="text" value="<?php echo $wcemessage_saved_text; ?>" name="wcemessage_search_<?php echo $statusName; ?>" id="wcemessage_search_<?php echo $statusName; ?>" placeholder="<?php echo __( 'Search Custom Messages...', 'woocommerce' ); ?>" autocomplete="off"></input>
										<?php
									} else {
										// Order Status assigned, but No WCE Message assigned = probably not a real world scenario
										$wcemessage_controls = $extraBtnContainerOpen . $extraBtnContainerClose;
										?>
										<input class="wcemessage_search_field_input" type="text" name="wcemessage_search_<?php echo $statusName; ?>" id="wcemessage_search_<?php echo $statusName; ?>" placeholder="<?php echo __( 'Search Custom Messages...', 'woocommerce' ); ?>" autocomplete="off"></input>
										<?php
									}

								} else {
									// No previous WCE data saved
									$wcemessage_controls = $extraBtnContainerOpen . $extraBtnContainerClose;
									?>
									<input class="wcemessage_search_field_input" type="text" name="wcemessage_search_<?php echo $statusName; ?>" id="wcemessage_search_<?php echo $statusName; ?>" placeholder="<?php echo __( 'Search Custom Messages...', 'woocommerce' ); ?>" autocomplete="off"></input>
									<?php
								}

							}
							?>
							<div class="wcemessage_search_results hide" id="wcemessage_<?php echo $statusName; ?>_search_results">
								<div class="wcemessage_search_results_wrap">
									<p class="placeholder"><?php echo __( 'Search results will appear here', 'woocommerce' ); ?></p>
								</div>
							</div>
						</div>
						<?php
						echo $wcemessage_controls;

						$hiddenFieldVal = '';

						// if NEW 2.2.0 data is saved for this Order Status
						if ( !empty( $wcemessage_id_currentStatus ) ) {
							$hiddenFieldVal = $wcemessage_id_currentStatus;
						} else if ( $customcontent_orderstatus == ( 'woocommerce_order_status_'.$statusSlug ) ) {
							$hiddenFieldVal = $wcemessage_id;
						}
						?>
						<input class="wcemessage_search_field_hidden" type="hidden" name="wcemessage_id_<?php echo $statusName; ?>" id="wcemessage_id_<?php echo $statusName; ?>" value="<?php echo $hiddenFieldVal; ?>" />
						<?php
					}

					/*
					* Reusable function to return a drop down menu of template locations
					*/
					function showLocationSelect( $statusName = '' ){

						$location_select_arr = array(
							'woocommerce_email_before_order_table' => __( 'Before Order Table', 'woocommerce' ),
							'woocommerce_email_after_order_table' => __( 'After Order Table', 'woocommerce' ),
							'woocommerce_email_order_meta' => __( 'After Order Meta', 'woocommerce' ),
							'woocommerce_email_customer_details' => __( 'After Customer Details', 'woocommerce' )
						);

						if ($statusName == 'onhold'){
							$statusSlug = 'on-hold';
						} else {
							$statusSlug = $statusName;
						}

						$currentStatusLocation = get_post_meta( get_the_ID(), 'location_'.$statusName, true );
						$old_orderStatus = get_post_meta( get_the_ID(), 'order_status', true );
						$old_orderLocation = get_post_meta( get_the_ID(), 'location', true );

						// if NEW 2.2.0 data is saved for this Order Status
						if ( !empty( $currentStatusLocation ) ) {

							// Select with New Saved Value
							woocommerce_wp_select(
								array(
									'id' => $statusName.'-location',
									'label' => '',
									'options' => $location_select_arr,
									'desc_tip' => false,
									'value' => $currentStatusLocation	// Use new saved value
								)
							);

						} else {

							// if previous data has been saved for the current Order Status
							if ( $old_orderStatus == ( 'woocommerce_order_status_'.$statusName ) ){

								// if previous data is saved for this Order Status
								if ( !empty( $old_orderLocation ) ) {

									// Select with Old Saved Value
									woocommerce_wp_select(
										array(
											'id' => $statusName.'-location',
											'label' => '',
											'options' => $location_select_arr,
											'desc_tip' => false,
											'value' => $old_orderLocation	// Use old saved value
										)
									);
								} else {
									// Select with no Default Value
									woocommerce_wp_select(
										array(
											'id' => $statusName.'-location',
											'label' => '',
											'options' => $location_select_arr,
											'desc_tip' => false,
										)
									);
								}

							} else {
								// No data has been saved for the current Order Status

								// Select with no Default Value
								woocommerce_wp_select(
									array(
										'id' => $statusName.'-location',
										'label' => '',
										'options' => $location_select_arr,
										'desc_tip' => false,
									)
								);
							}

						}

					}
					?>

					<!-- // ON-HOLD ***************************************************** // -->
					<div class="table-row">
						<div class="status order_status">
							<mark class="order-status status-on-hold">
								<span><?php echo __( 'On hold', 'woocommerce' ); ?></span>
							</mark>
						</div>
						<div class="message">
							<?php showSavedMessage('onhold'); ?>
						</div>
						<div class="location">
							<?php showLocationSelect('onhold'); ?>
						</div>
					</div>

					<!-- // PROCESSING ***************************************************** // -->
					<div class="table-row">
						<div class="status order_status">
							<mark class="order-status status-processing">
								<span><?php echo __( 'Processing', 'woocommerce'); ?></span>
							</mark>
						</div>
						<div class="message">
							<?php showSavedMessage('processing'); ?>
						</div>
						<div class="location">
							<?php showLocationSelect('processing'); ?>
						</div>
					</div>

					<!-- // COMPLETED ***************************************************** // -->
					<div class="table-row">
						<div class="status order_status">
							<mark class="order-status status-completed">
								<span><?php echo __( 'Completed', 'woocommerce' ); ?></span>
							</mark>
						</div>
						<div class="message">
							<?php showSavedMessage('completed'); ?>
						</div>
						<div class="location">
							<?php showLocationSelect('completed'); ?>
						</div>
					</div>

				</div>

			</div>

		</div>
		<?php
	}

	//* AJAX Fetch JS
	public function ajax_wce_fetch_script() {
	?>
		<script type="text/javascript">
		function fetch_wce_posts_onhold(){
			jQuery.ajax({
				url: '<?php echo admin_url('admin-ajax.php'); ?>',
				type: 'post',
				data: { action: 'wce_data_fetch', keyword: jQuery('#wcemessage_search_onhold').val() },
				success: function(data) {
					jQuery('#wcemessage_onhold_search_results .wcemessage_search_results_wrap').html( data );
				}
			});
		}

		function fetch_wce_posts_processing(){
			jQuery.ajax({
				url: '<?php echo admin_url('admin-ajax.php'); ?>',
				type: 'post',
				data: { action: 'wce_data_fetch', keyword: jQuery('#wcemessage_search_processing').val() },
				success: function(data) {
					jQuery('#wcemessage_processing_search_results .wcemessage_search_results_wrap').html( data );
				}
			});
		}

		function fetch_wce_posts_completed(){
			jQuery.ajax({
				url: '<?php echo admin_url('admin-ajax.php'); ?>',
				type: 'post',
				data: { action: 'wce_data_fetch', keyword: jQuery('#wcemessage_search_completed').val() },
				success: function(data) {
					jQuery('#wcemessage_completed_search_results .wcemessage_search_results_wrap').html( data );
				}
			});
		}

		jQuery(document).ready( function($) {

			// Apply onkeyup behavior
			$('#wcemessage_search_onhold').keyup(function () {
				fetch_wce_posts_onhold();
			});

			$('#wcemessage_search_processing').keyup(function () {
				fetch_wce_posts_processing();
			});

			$('#wcemessage_search_completed').keyup(function () {
				fetch_wce_posts_completed();
			});

			// Show Content button
			$(document).on('click', '.show-oldcustomcontent', function(e){
				// Don't jump to top of page
				e.preventDefault();

				// Hide this button
				$(this).addClass('hide');

				// Show 'Hide Content' button
				$('.button.hide-oldcustomcontent.hide').removeClass('hide');

				// Show 'Custom Content' textarea
				$('#old-customcontent-meta.hide').removeClass('hide');
			});

			// Hide Content button
			$(document).on('click', '.hide-oldcustomcontent', function(e){
				// Don't jump to top of page
				e.preventDefault();

				// Hide this button
				$(this).addClass('hide');

				// Show 'Show Content' button
				$('.button.show-oldcustomcontent.hide').removeClass('hide');

				// Hide 'Custom Content' textarea
				$('#old-customcontent-meta').addClass('hide');
			});

			/* ---------------------------- 2.2.0 --------------------------- */

			var allHidden = false;

			function hideAllSearchResultsBoxes() {

				if ( allHidden !== true ) {

					// Hide all SR boxes
					$('.wcemessage_search_results').addClass('hide');

					// Assign 'allHidden' var to true
					allHidden = true;

				}

			}

			function hideSearchResultsBox(thisElem) {
				// Add 'hide' class to closest SR box
				thisElem.closest('.message').find('.wcemessage_search_results').addClass('hide');
			}

			function showSearchResultsBox(thisElem) {
				// Remove 'hide' class from closest SR box
				thisElem.closest('.message').find('.wcemessage_search_results').removeClass('hide');
				allHidden = false;
			}

			// Click functions
			$(document).on('click', function(e) {

				var target = e.target;
				var targetClass = target.className;

				if ( targetClass == 'wcemessage_search_field_input' ) {

					/* SEARCH FIELD CLICKED - SHOW SEARCH RESULTS MODAL
					--------------------------------------------------------- */

					// Don't jump to top of page
					e.preventDefault();

					// Hide all search results elements
					$('.wcemessage_search_results').addClass('hide');

					// Remove 'hide' class from closest search results box
					showSearchResultsBox( $(e.target) );

					// Focus on the search results box that was clicked
					$(e.target).closest('.message').focus();

				} else if ( targetClass == 'wce-search-result' ) {

					/* SEARCH RESULT CLICKED - ASSIGN CUSTOM EMAIL MESSAGE
					--------------------------------------------------------- */

					// Don't jump to top of page
					e.preventDefault();

					// Define vars
					var theid = $(e.target).attr('data-id');
					var thetitle = $(e.target).attr('data-title');

					// Update field values
					$(e.target).closest('.table-row').find('.wcemessage_search_field_hidden').val(theid);	// hidden field
					$(e.target).closest('.table-row').find('.wcemessage_search_field_input').val(thetitle);	// search field

					// Add a new 'Remove' button if not already present
					$(e.target).closest('.table-row').find('.button-container:not(.remove)').addClass('remove').html('<a href="#" class="button remove-wcemessage" alt="Remove" title="Remove"><span class="dashicons dashicons-no"></span></a>');

					// Add 'hide' class to closest search results box
					hideSearchResultsBox( $(e.target) );

				} else {

					/* NORMAL PAGE ELEMENT CLICKED - HIDE ALL SEARCH RESULTS BOXES
					--------------------------------------------------------- */

					hideAllSearchResultsBoxes();

				}

			});

			// Remove button
			$(document).on('click', '.remove-wcemessage', function(e) {

				// Don't jump to top of page
				e.preventDefault();

				// Hide Edit buttons
				$(this).closest('.table-row').find('.button-container').find('.button').addClass('hide');

				// Remove field values
				$(this).closest('.table-row').find('.wcemessage_search_field_input').val('');
				$(this).closest('.table-row').find('.wcemessage_search_field_hidden').val('');

				// Remove CSS classes
				$(this).closest('.button-container').removeClass('remove');
				$(this).closest('.button-container').removeClass('edit');

			});

		});
		</script>
		<?php
	}

	// AJAX Fetch function.
	public function wce_data_fetch() {

		$search_term = esc_attr( $_POST['keyword'] );

		$args = array(
			'post_type' => 'woocustomemails',
			'post_status' => 'publish',
			'posts_per_page' => -1,
			's' => $search_term
		);

		$the_query = new WP_Query($args);

		if( $the_query->have_posts() ) {
			while( $the_query->have_posts() ): $the_query->the_post();

				$thePermalink = esc_url( post_permalink() );
				$theID = get_the_ID();
				$theTitle = get_the_title();
				?>
				<p><a href="#" class="wce-search-result" data-id="<?php echo $theID; ?>" data-title="<?php echo $theTitle; ?>"><?php echo $theID; ?> - <?php echo $theTitle; ?></a></p>
				<?php
			endwhile;
			wp_reset_postdata();
		} else {
			$addMessagesURL = admin_url('edit.php?post_type=woocustomemails');
			$addMessagesText = '<a href="'.$addMessagesURL.'" target="_blank" class="edit-wcemessage">'.__('Custom Email Messages','woocommerce').'</a>';
			?>
			<p class="placeholder error"><?php echo __( 'Sorry! No posts match your search. Please add some ', 'woocommerce' ) . $addMessagesText . __( ' and try again.', 'woocommerce' ) ?></p>
			<?php
		}

		die();
	}


	/** Hook callback function to save custom fields information */
	public function save_woo_custom_emails_tab_fields( $post_id ) {

		// Save Order Status
	    $select = $_POST['order_status'];
	    if ( !empty( $select ) ) {
	        update_post_meta( (int) $post_id, 'order_status', (string) esc_attr( $select ) );
	    }

		// Save 'wcemessage_id' Hidden Field
        update_post_meta( $post_id, 'wcemessage_id', $_POST['wcemessage_id'] );

	    // Save Order Status
	    $select = $_POST['location'];
	    if ( !empty( $select ) ) {
	        update_post_meta( $post_id, 'location', esc_attr( $select ) );
	    }

		/* 2.2.0
		********************************************************************* */
		update_post_meta( $post_id, 'wcemessage_id_onhold', $_POST['wcemessage_id_onhold'] );
		update_post_meta( $post_id, 'location_onhold', esc_attr( $_POST['onhold-location'] ) );

		update_post_meta( $post_id, 'wcemessage_id_processing', $_POST['wcemessage_id_processing'] );
		update_post_meta( $post_id, 'location_processing', esc_attr( $_POST['processing-location'] ) );

		update_post_meta( $post_id, 'wcemessage_id_completed', $_POST['wcemessage_id_completed'] );
		update_post_meta( $post_id, 'location_completed', esc_attr( $_POST['completed-location'] ) );

	}

}
