<?php

/**
 * This file is part of the ramsey/uuid library
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 *
 * @copyright Copyright (c) Ben Ramsey <ben@benramsey.com>
 * @license http://opensource.org/licenses/MIT MIT
 * @link https://benramsey.com/projects/ramsey-uuid/ Documentation
 * @link https://packagist.org/packages/ramsey/uuid Packagist
 * @link https://github.com/ramsey/uuid GitHub
 */
namespace PixelCaffeine\Dependencies\Ramsey\Uuid\Generator;

use PixelCaffeine\Dependencies\Ramsey\Uuid\Converter\TimeConverterInterface;
use PixelCaffeine\Dependencies\Ramsey\Uuid\Provider\NodeProviderInterface;
use PixelCaffeine\Dependencies\Ramsey\Uuid\Provider\TimeProviderInterface;
/**
 * A factory for retrieving a time generator, based on the environment
 */
class TimeGeneratorFactory
{
    /**
     * @var NodeProviderInterface
     */
    private $nodeProvider;
    /**
     * @var TimeConverterInterface
     */
    private $timeConverter;
    /**
     * @var TimeProviderInterface
     */
    private $timeProvider;
    /**
     * Constructs a `TimeGeneratorFactory` using a node provider, time converter,
     * and time provider
     *
     * @param NodeProviderInterface $nodeProvider
     * @param TimeConverterInterface $timeConverter
     * @param TimeProviderInterface $timeProvider
     */
    public function __construct(\PixelCaffeine\Dependencies\Ramsey\Uuid\Provider\NodeProviderInterface $nodeProvider, \PixelCaffeine\Dependencies\Ramsey\Uuid\Converter\TimeConverterInterface $timeConverter, \PixelCaffeine\Dependencies\Ramsey\Uuid\Provider\TimeProviderInterface $timeProvider)
    {
        $this->nodeProvider = $nodeProvider;
        $this->timeConverter = $timeConverter;
        $this->timeProvider = $timeProvider;
    }
    /**
     * Returns a default time generator, based on the current environment
     *
     * @return TimeGeneratorInterface
     */
    public function getGenerator()
    {
        return new \PixelCaffeine\Dependencies\Ramsey\Uuid\Generator\DefaultTimeGenerator($this->nodeProvider, $this->timeConverter, $this->timeProvider);
    }
}
