(function($) {
	$(function() {
			$( 'body' ).on( 'click', '.gf-spreadsheet-clear-cache', function(event) {
					event.preventDefault()
					window.location.search += '&frmclrcache=1';
			});

			GfGoogleSpreadsheetSync = {
				init:function() {
					this.clickEvent();
				},
				clickEvent:function() {
					var self = this;
					$( 'body' ).on( 'click', '#googlespreadsheet-sync-gf-entries', function( event ) {
						var $el = $( this );
						var formId = $el.data( 'form-id' );
						var actionId = $el.data( 'feed-id' );
						var cnf = confirm( 'Are you sure you want to send existing entries data to sheet?' );
						event.preventDefault();

						if ( cnf ) {
							if ( '' == formId || '' == actionId ) {
								alert( 'Please save the form first.' );
								return;
							}
							data = {
								action: 'gf_sync_entries_google_spreadsheet',
								formid: formId,
								actionid: actionId,
							};

							// Spreadsheet spinner.
							$el.next().css( 'visibility', 'visible' );

							// Start the process
							self.process_step( 1, data, self, $el );
						}
					} );
				},
				process_step:function( step, data, self, $el ) {
					data.step = step;
					$.post( ajaxurl, data, function( resp ) {
						var result = $.parseJSON( resp );
						if ( 'success' === result.response ) {
							if ( 'complete' == result.step ) {
								$el.next().css( 'visibility', 'hidden' );
							} else {
								self.process_step( parseInt( result.step ), data, self, $el );
							}
							$( '.spreadsheet_sync_result' ).text( result.processed ).show();
						} else {
							$( '.spreadsheet_sync_result' ).text( result.error_detail ).show();
						}
					} );
				}
			};
			GfGoogleSpreadsheetSync.init();

		});
})( jQuery )
