<?php
class GFSpreadheet_Auth {

	/**
	 * Add necessary hooks and filters functions
	 *
	 * @author Aman Saini
	 * @since  1.0
	 */
	function __construct() {

	}

	public static function gf_finish_code_exchange( $die = true ) {
		$token = self::set_oauth2_token( $_POST['auth_code'], 'auth_code' );
		if ( $die ) {
			echo $token;
			wp_die();
		}
	}

	// get access or refresh token
	public static function set_oauth2_token( $grantCode, $grantType ) {
		$settings = get_option( 'gravityformsaddon_gfspreadsheet_settings' );

		$authsettings = get_option( 'gf_spreadsheet_auth', true );

		$success          = true;
		$oauth2token_url  = GFSPREADSHEET_OAUTH2_TOKEN_URI;
		$clienttoken_post = array(
			'client_id'     => $settings['client_id'],
			'client_secret' => $settings['client_secret'],
		);
		// redirect url
		$redirect_uri = trailingslashit( home_url() );

		if ( $grantType === 'auth_code' ) {
			// The "auth_code" grant type is to do the initial code exchange
			$clienttoken_post['code']         = $grantCode;
			$clienttoken_post['redirect_uri'] = 'oob';
			$clienttoken_post['grant_type']   = 'authorization_code';
		}
		if ( $grantType === 'refresh_token' ) {
			// The "refresh token" grant type is to use a refresh token to get a new access token
			$clienttoken_post['refresh_token'] = $authsettings['refresh_token'];
			$clienttoken_post['grant_type']    = 'refresh_token';
		}
		$postargs = array(
			'body' => $clienttoken_post,
		);

		$response = wp_remote_post( $oauth2token_url, $postargs );

		$authObj  = json_decode( wp_remote_retrieve_body( $response ), true );
		// print_r($authObj);
		if ( ! empty( $authObj['access_token'] ) ) {

			if ( ! is_array( $authsettings ) ) {
				$authsettings = array();
			}

			if ( isset( $authObj['refresh_token'] ) ) {
				$authsettings['refresh_token'] = $authObj['refresh_token'];
				$success                       = update_option( 'gf_spreadsheet_auth', $authsettings, false );
				// the final 'false' is so we don't autoload this value into memory on every page load
			}
			if ( isset( $authObj['access_token'] ) ) {
				$authsettings['access_token'] = $authObj['access_token'];
				$authsettings['expires_in']   = strtotime( '+' . $authObj['expires_in'] . ' seconds' );
				$access_token                 = $authObj['access_token'];
				$success                      = update_option( 'gf_spreadsheet_auth', $authsettings, false );
			}
		} else {
			$success = false;
		}
		// if there were any errors $success will be false, otherwise it'll be the access token
		if ( ! $success ) {
			$success = 'it failed'; }
		if ( ! empty( $access_token ) ) {
			return $access_token;
		}

	}


	public static function get_access_token( $new = false ) {
		$authsettings    = get_option( 'gf_spreadsheet_auth', true );
		$expiration_time = $authsettings['expires_in'];
		if ( ! $expiration_time ) {
			return false;
		}
		// Give the access token a 5 minute buffer (300 seconds)
		$expiration_time = $expiration_time - 300;
		if ( time() < $expiration_time ) {
			return $authsettings['access_token'];

		}
		// at this point we have an expiration time but it is in the past or will be very soon
			return self::set_oauth2_token( null, 'refresh_token' );
	}


	public static function revoke() {

		$authsettings     = get_option( 'gf_spreadsheet_auth', true );
		$oauth2revoke_url = GFSPREADSHEET_OAUTH2_REVOKE_URI;
		if ( ! empty( $authsettings['refresh_token'] ) ) {
			$oauth2revoke_url = $oauth2revoke_url . '?token=' . $authsettings['refresh_token'];
			$data             = wp_remote_get( $oauth2revoke_url );
			$response         = wp_remote_retrieve_body( $data );
			delete_option( 'gf_spreadsheet_auth' );
			// print_r( $data );
			die;
		} elseif ( ! empty( $authsettings['access_token'] ) ) {
			$oauth2revoke_url = $oauth2revoke_url . '?token=' . $authsettings['access_token'];
			$data             = wp_remote_get( $oauth2revoke_url );
			$response         = wp_remote_retrieve_body( $data );
			delete_option( 'gf_spreadsheet_auth' );
			// print_r( $data );
			die;
		}

	}
}
